/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.util.CmdExtendedError;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.fsp.ParamConvertor;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class PhypExtErrHelper {
    static final String IO_ADAPTER = "IO_ADAPTER";
    static final String SNI_ADAPTER = "SNI_ADAPTER";
    static final String RIO_BUS_NUM = "RIO_BUS_NUM";
    static final String VIO_SLOT_NUM = "VIO_SLOT_NUM";
    private static PhypExtErrHelper mInst = null;
    private long[] mExtErrCodes = new long[]{0x40000002L, 0x40000003L, 0x40000004L, 0x40000022L, 1073741859L, 0x40000024L, 1073741863L, 0x40000042L, 0x40000043L, 0x40000044L, 0x40000047L, 1073741922L, 1073741923L, 0x40000064L, 1073741953L, 1073741954L, 1073741955L, 0x40000084L, 1073741957L, 1073741958L, 1073741985L, 1073741986L, 1073742017L, 1073742018L, 1073742019L, 0x400000C4L, 1073742022L, 1073742023L, 1073742024L, 1073742025L, 1073742026L, 1073742027L, 1073742030L, 1073742031L, 0x400000D0L, 1073742033L, 1073742035L, 0x400000D4L, 1073742038L, 1073742040L, 1073742041L, 1073742042L, 1073742043L, 1073742044L, 0x400000DDL, 1073742047L, 0x40000140L, 1073742146L, 1073742147L, 0x40000144L, 1073742149L, 1073742150L, 1073742151L, 1073742152L, 1073742153L, 1073742209L, 1073742210L, 1073742211L, 1073742213L, 1073742214L, 1073742215L, 1073742216L, 1073742217L, 1073742218L, 1073742219L, 1073742220L, 1073742339L, 0x40000504L, 1073743111L, 1073799169L, 1073799170L, 1073799171L, 1073742015L, 0x40000005L, 1073741864L, 1073742014L};
    private String[] mExceptionIds = new String[]{"1450", "1451", "1452", "1453", "1454", "1455", "1456", "1457", "1458", "1459", "145A", "145B", "145C", "145D", "145E", "145F", "1460", "1461", "1462", "1463", "1464", "1465", "1466", "1467", "1468", "1469", "146A", "146B", "146C", "146D", "146E", "146F", "1472", "1473", "1474", "1475", "1477", "1478", "1479", "147A", "147B", "147C", "147D", "147E", "147F", "1481", "150B", "150C", "150D", "150E", "150F", "1510", "1511", "1512", "1513", "1514", "1515", "1516", "1517", "1518", "1519", "151A", "151B", "151C", "151D", "151E", "1523", "152A", "152D", "1537", "1538", "1539", "1556", "1553", "1554", "1555"};
    private String[][] mArgTypes = new String[][]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {"IO_ADAPTER"}, null, null, null, null, null, {"SNI_ADAPTER"}, null, null, null, null, null, null, {"RIO_BUS_NUM"}, null, {"IO_ADAPTER"}, null, null, null, null, null, {"IO_ADAPTER"}, {"IO_ADAPTER"}, {"IO_ADAPTER"}, {"IO_ADAPTER"}, null, {"IO_ADAPTER"}, null, null, null, null, null, null, null, null, null, null, {"VIO_SLOT_NUM"}, {"VIO_SLOT_NUM"}, null, null, null, null, null, null, null, {"VIO_SLOT_NUM"}, null, null, {"VIO_SLOT_NUM"}};

    public static PhypExtErrHelper getInstance() {
        if (mInst == null) {
            mInst = new PhypExtErrHelper();
        }
        return mInst;
    }

    private PhypExtErrHelper() {
    }

    public PIHscCmdMgrException convertException(ParamConvertor paramConvertor, Hashtable hashtable, PIHscCmdMgrException pIHscCmdMgrException) {
        if (!pIHscCmdMgrException.isExtendedError()) {
            System.out.println("origExc exception is not extended error");
            return pIHscCmdMgrException;
        }
        CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
        int n = cmdExtendedErrorList.getNumberOfErrors();
        System.out.println("errsize: " + n);
        if (n == 1) {
            return this.cvtForSingleErr(paramConvertor, hashtable, pIHscCmdMgrException);
        }
        if (n > 1) {
            return this.cvtForErrList(paramConvertor, hashtable, pIHscCmdMgrException);
        }
        return pIHscCmdMgrException;
    }

    private PIHscCmdMgrException cvtForSingleErr(ParamConvertor paramConvertor, Hashtable hashtable, PIHscCmdMgrException pIHscCmdMgrException) {
        CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
        CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
        int n = this.getNdxFromErrCode(cmdExtendedError);
        if (n == -1) {
            return new PIHscCmdMgrException("1552", null, pIHscCmdMgrException);
        }
        Hashtable hashtable2 = this.getOutParams(paramConvertor, cmdExtendedError);
        String[] stringArray = this.getMsgArgs(hashtable, hashtable2, n);
        return new PIHscCmdMgrException(this.mExceptionIds[n], stringArray, pIHscCmdMgrException);
    }

    private PIHscCmdMgrException cvtForErrList(ParamConvertor paramConvertor, Hashtable hashtable, PIHscCmdMgrException pIHscCmdMgrException) {
        CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
        CmdExtendedError[] cmdExtendedErrorArray = cmdExtendedErrorList.getErrorArray();
        String[] stringArray = new String[]{pIHscCmdMgrException.getCommandMessage(), "" + cmdExtendedErrorArray.length, "\n"};
        boolean bl = false;
        for (int i = 0; i < cmdExtendedErrorArray.length; ++i) {
            int n = this.getNdxFromErrCode(cmdExtendedErrorArray[i]);
            if (n == -1) {
                stringArray[2] = stringArray[2] + this.getDefaultMsg(cmdExtendedErrorArray[i]) + "\n";
                continue;
            }
            Hashtable hashtable2 = this.getOutParams(paramConvertor, cmdExtendedErrorArray[i]);
            stringArray[2] = stringArray[2] + this.getExceptionMsg(hashtable, hashtable2, n) + "\n";
            bl = true;
        }
        if (!bl) {
            System.out.println("cannot find msg for all errors in the list");
            return new PIHscCmdMgrException("1552", null, pIHscCmdMgrException);
        }
        return new PIHscCmdMgrException("1550", stringArray, pIHscCmdMgrException);
    }

    private String getDefaultMsg(CmdExtendedError cmdExtendedError) {
        long l = cmdExtendedError.extractErrorCode();
        return HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", "1551", "", new String[]{"" + l});
    }

    private Hashtable getOutParams(ParamConvertor paramConvertor, CmdExtendedError cmdExtendedError) {
        return null;
    }

    private int getNdxFromErrCode(CmdExtendedError cmdExtendedError) {
        long l = cmdExtendedError.extractErrorCode();
        for (int i = 0; i < this.mExtErrCodes.length; ++i) {
            if (l != this.mExtErrCodes[i]) continue;
            System.out.println("the index for errCode " + l + " is " + i);
            return i;
        }
        System.out.println("errCode: " + l + " is not in the msg list");
        return -1;
    }

    private String getExceptionMsg(Hashtable hashtable, Hashtable hashtable2, int n) {
        String[] stringArray = this.getMsgArgs(hashtable, hashtable2, n);
        return HSCResourceBundleUtil.encodeNLSMsg("HSCCIMExceptionBundle", this.mExceptionIds[n], "", stringArray);
    }

    private String[] getMsgArgs(Hashtable hashtable, Hashtable hashtable2, int n) {
        if (this.mArgTypes[n] == null) {
            return null;
        }
        String[] stringArray = this.mArgTypes[n];
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = hashtable2 != null ? hashtable2.get(stringArray[i]).toString() : null;
            if (stringArray2[i] != null || hashtable == null) continue;
            stringArray2[i] = hashtable.get(stringArray[i]).toString();
        }
        return stringArray2;
    }

    public Hashtable getInParams(ParamConvertor paramConvertor, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163) {
        System.out.println("ioSlotDrcNdx: " + unsignedInt32);
        System.out.println("sniAdapterId: " + unsignedInt16);
        System.out.println("rioBusNum: " + unsignedInt162);
        System.out.println("vioSlotNum: " + unsignedInt163);
        if (paramConvertor == null) {
            return null;
        }
        if (unsignedInt32 == null && unsignedInt16 == null && unsignedInt162 == null && unsignedInt163 == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (unsignedInt32 != null) {
            System.out.println("has ioSlotDrcNdx: " + unsignedInt32);
            String string = paramConvertor.drcIndexToLocationCode(unsignedInt32);
            if (string != null) {
                System.out.println("got location code: " + string);
                hashtable.put(IO_ADAPTER, string);
            } else {
                hashtable.put(IO_ADAPTER, "" + unsignedInt32);
            }
        }
        if (unsignedInt16 != null) {
            System.out.println("has sniAdapterId: " + unsignedInt16);
            hashtable.put(SNI_ADAPTER, "" + unsignedInt16);
        }
        if (unsignedInt162 != null) {
            System.out.println("has rioBusNum: " + unsignedInt162);
            hashtable.put(RIO_BUS_NUM, "" + unsignedInt162);
        }
        if (unsignedInt163 != null) {
            System.out.println("has vioSlotNum: " + unsignedInt163);
            hashtable.put(VIO_SLOT_NUM, "" + unsignedInt163);
        }
        return hashtable;
    }
}

